/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.animation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.item.StashDetectorItem;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_RequestStashDetectorStatus;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.event.IAnimationEventSerializer;
import lib.toma.animations.engine.AbstractAnimationEvent;
import lib.toma.animations.engine.screen.SelectionButton;
import lib.toma.animations.engine.screen.animator.dialog.EventCreateDialog;
import lib.toma.animations.engine.screen.animator.dialog.EventDialogContext;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class StashDetectorEvent
extends AbstractAnimationEvent {
    private final StashDetectorItem.StatusEvent status;

    public StashDetectorEvent(float target, StashDetectorItem.StatusEvent status) {
        super(ModAnimations.STASH_DETECTOR_EVENT, target);
        this.status = status;
    }

    @Override
    public void dispatch(Minecraft client, IAnimation fromAnimation) {
        NetworkManager.sendServerPacket(new C2S_RequestStashDetectorStatus(this.status));
    }

    @Override
    public IAnimationEvent copyAt(float target) {
        return new StashDetectorEvent(target, this.status);
    }

    public static final class StashDetectorEventDialog
    extends EventCreateDialog<StashDetectorEvent> {
        private SelectionButton<StashDetectorItem.StatusEvent> statusSelector;

        public StashDetectorEventDialog(EventDialogContext<StashDetectorEvent> context) {
            super(context);
        }

        @Override
        protected void preInit() {
            this.setDimensions(150, 65);
        }

        @Override
        protected StashDetectorEvent construct() {
            EventDialogContext context = this.getContext();
            return new StashDetectorEvent(context.getTarget(), this.statusSelector.getValue());
        }

        @Override
        protected void addWidgets() {
            int elWidth = this.dWidth() - 10;
            int btWidth = (elWidth - 5) / 2;
            this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 15, btWidth, 20, (ITextComponent)new StringTextComponent("Status"), this.field_230712_o_));
            this.statusSelector = (SelectionButton)this.func_230480_a_(new SelectionButton<StashDetectorItem.StatusEvent>(this.left() + 10 + btWidth, this.top() + 15, btWidth, 20, StashDetectorItem.StatusEvent.values()));
            this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 40, btWidth, 20, CANCEL, this::cancel_clicked));
            this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btWidth, this.top() + 40, btWidth, 20, CONFIRM, this::confirm_clicked));
        }
    }

    public static final class Serializer
    implements IAnimationEventSerializer<StashDetectorEvent> {
        @Override
        public JsonElement serialize(StashDetectorEvent event, JsonSerializationContext context) {
            return new JsonPrimitive((Number)event.status.ordinal());
        }

        @Override
        public StashDetectorEvent deserialize(float target, JsonElement src, JsonDeserializationContext context) throws JsonParseException {
            int index = src.getAsInt();
            StashDetectorItem.StatusEvent event = StashDetectorItem.StatusEvent.values()[index];
            return new StashDetectorEvent(target, event);
        }
    }
}

